package main

import (
	"encoding/json"
	"fmt"
	"go/ast"
	"go/parser"
	"go/token"
	"io/ioutil"
	"os"
	"log"
	"bufio"
)

func main() {
	filePath := getFilepathArg()
	targetFile := getFilepathArgSecond()
	file, err := os.Open(filePath)
	check(err)
	defer file.Close()

	writeToThis, errrd := os.Create(targetFile)
	check(errrd)
	defer writeToThis.Close()

	scanner := bufio.NewScanner(file)
	for scanner.Scan() {
		importsJson := GetImportsJson(scanner.Text())
		//combined := filePath + "<<<Separator>>>" + parsedJson
		_, err1 := writeToThis.WriteString(scanner.Text() + "<<<Separator>>>")
		_, err2 := writeToThis.Write(importsJson)
		_, err3 := writeToThis.WriteString("\n")
		check(err1)
		check(err2)
		check(err3)
	}

	
	if err := scanner.Err(); err != nil {
		log.Fatal(err)
	}
	if errrd := scanner.Err(); errrd != nil {
		log.Fatal(err)
	}
}

func check(e error) {
    if e != nil {
        log.Fatal(e)
    }
}

func getFilepathArg() string {
	argsWithoutProg := os.Args[1:]
	filePath := argsWithoutProg[0]
	return filePath
}

func getFilepathArgSecond() string {
	argsWithoutProg := os.Args[1:]
	filePath := argsWithoutProg[1]
	return filePath
}

func GetImportsJson(filePath string) []byte {
	contents, err := ioutil.ReadFile(filePath)
	if err != nil {
		exitWithError("Couldn't read file at " + filePath + "\nErr=" + err.Error())
	}
	imports := GetImports(string(contents))
	return toJson(imports)

}

func toJson(imports []string) []byte {
	jsonImports, _ := json.Marshal(imports)
	return jsonImports
}

func exitWithError(errorMessage string) {
	_, _ = fmt.Fprintf(os.Stderr, errorMessage+"\n")
	os.Exit(1)
}

func GetImports(sourceCode string) []string {
	fset := token.NewFileSet()
	var imports []string
	f, err := parser.ParseFile(fset, "dont-care", sourceCode, 0)
	if err != nil {
		return imports
	}
	ast.Inspect(f, func(n ast.Node) bool {
		var s string
		switch x := n.(type) {
		case *ast.ImportSpec:
			s = x.Path.Value
			imports = append(imports, s)
		}
		return true
	})
	return imports
}
