Unified System Agent
==============================

An [external update agent][1] for projects.

The agent looks for open source usage in your projects and update your [Mend][2] account.

### Getting Started
Setup and configuration along with comprehensive documentation could be found [here][3].
Technical information about the plugin could be found [here][3].

### Support
You can always create an issue or tell our support team what you think [here][4].

### License
The project is licensed under the WhiteSource Software End User License Agreement .
<pre>
Copyright (C) 2015 WhiteSource Ltd.

Licensed under the WhiteSource Software End User License Agreement;
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

https://s3.amazonaws.com/unified-agent/LICENSE.txt

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS.
</pre>

[1]: http://www.github.com/whitesource/agents
[2]: http://www.mend.io
[3]: https://whitesource.atlassian.net/wiki/spaces/WD/pages/33718339/Unified+Agent
[4]: mailto:support@whitesourcesoftware.com
[5]: https://s3.amazonaws.com/unified-agent/LICENSE.txt


## Prerequisites

Before you can build and run this project, ensure you have the following software installed on your system:
- **Java**: One of the following: Java JDK 8, Java JRE 8, Java JDK 11, Java JDK 17
- **Maven**

## Build
We use Maven to build this project.

### About Maven
Maven is a project management tool widely used for Java projects. It automates the process of building software by handling project dependencies, compiling source code, and packaging binaries. Maven utilizes an XML file (Project Object Model or POM) to describe the project structure, dependencies, and build configuration. This ensures consistent builds and simplifies the management of project libraries. In this project, Maven is used to streamline the build process, manage dependencies, and ensure that all contributors can build the project in a consistent environment.


## Building the Unified Agent JAR

### What is a Fat JAR?

A Fat JAR, also known as an Uber JAR, is a single executable JAR file that contains all of the compiled classes along with all of the JAR files it depends on. This simplifies deployment and execution since all dependencies are packaged together.

### How to Build

To build the Unified Agent JAR file, navigate to the `unified-agent-main` directory and use Maven:

```bash
cd unified-agent-main
mvn package
```

This command compiles the project and packages it into a Fat JAR file.

#### Skipping Tests
If you wish to build the JAR without running tests, you can do so by appending `-DskipTests` to the Maven command:

## Building the Project
To build the entire project and install it to your local Maven repository without running tests, navigate to `unified-agent-main` and run: 
```bash
mvn clean install -DskipTests
```

## Running the Unified Agent

To learn how to get started with unified agent, be sure to read the relevant [docs](https://docs.mend.io/bundle/unified_agent/page/getting_started_with_the_unified_agent.html).

When running the Unified Agent, you can use a configuration file, environment variables, or CLI flags to set the necessary parameters.


### Setting the Minimum Required Configuration Parameters
Set the following configuration parameters, in any of the available methods, for the Unified Agent's execution:

| Parameter Name | Environment Variable Name | Configuration File Parameter Name | Command Line Parameter Name | Description |
| -------------- | ------------------------- | -------------------------------- | -------------------------- | ----------- |
| API Key        | WS_APIKEY                 | apiKey                           | -apiKey                    | The identifier of the organization. This can be found on the Integrate page of the Mend User Interface under the Organization section. Requires admin level access to see this page. |
| Mend URL       | WS_WSS_URL                | wss.url                          | -wss.url                   | The Server URL with `/agent` added. This can also be found on the Integrate page of the Mend User Interface under the Organization section. Requires admin level access to see this page. For example: `https://saas.whitesourcesoftware.com/agent` |
| User Key       | WS_USERKEY                | userKey                          | -userKey                   | Required when Enforce user level access is enabled within the Organization via Integrate → Advanced Settings. See the following link for how to generate a user key. Note: As of version 22.8.2, when creating a new Mend organization in the UI or API, the option Enforce user level access and New products are automatically assigned to the admin group are now enabled by default, thus providing greater security for organizations that require user key access. |
| Product Name   | WS_PRODUCTNAME            | productName                      | -product                   | The name of the product created after running a scan. |
| Project Name   | WS_PROJECTNAME            | projectName                      | -project                   | The name of the project created after running a scan. |

There's a vast amount of other parameters that can be set, which can be found in the [Unified Agent Configuration Parameters](https://docs.mend.io/bundle/unified_agent/page/unified_agent_configuration_parameters.html) documentation.

### Configuration File
The default name for the configuration file is `wss-unified-agent.config`, and its default location is in the same directory as the Fat JAR of the Unified Agent. You may place it anywhere, but then you have to specify its location in the configuration. For example, in the CLI, you have to use the `-c [path-to-config-file]` flag.

### Environment Variables
If you chose to use environment variables, you can set them in your system's environment variables or in your terminal before running the Unified Agent.

Example:

#### Linux / Darwin
```bash
export WS_APIKEY=<your-api-key>
export WS_USERKEY=<your-user-key>
export WS_PRODUCTNAME=<your-product-name>
export WS_PROJECTNAME=<your-project-name>
export WS_WSS_URL=https://saas.whitesourcesoftware.com/agent
```

#### Windows
```bash
set WS_APIKEY=<your-api-key>
set WS_USERKEY=<your-user-key>
set WS_PRODUCTNAME=<your-product-name>
set WS_PROJECTNAME=<your-project-name>
set WS_WSS_URL=https://saas.whitesourcesoftware.com/agent
```

### Running from Command Line

#### Prerequisites for Scanning Projects

*This is only relevant if you run Unified Agent on your local machine*

The Unified Agent can scan and find dependencies of projects using different package managers. To ensure a successful scan, you must have the required package manager installed on your system or available to the code.

For example, if you're scanning a Java project with Maven dependencies, ensure that you have Java and Maven installed on your system. If you're running the Unified Agent inside a Docker container, the container image should have Java and the necessary package manager installed.

#### Starting a scan
Start by setting the required configuration in one of the available methods specified above.

Using the Fat jar, run the Unified Agent:
```bash
java -jar wss-unified-agent.jar
```

By default, the Unified Agent will scan the directory where you run the command. However, you can specify a different directory using the `-d [project dir]` flag:

```bash
java -jar wss-unified-agent.jar -d /path/to/your/project
```